
 
; Adjust OSCCON
; initially runs using the existing calibration value


;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 

		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON  & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_CLKOUT	

; EEPROM
EEPROM0			equ	H'00'	; non-volatile storage 
; RAM 

STORE1			equ	H'20'	; delay counter	
STORE2			equ	H'21'	; delay counter
STORE3			equ	H'22'	; delay counter
CALIBRATE		equ	H'23'	; calibration

; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'80'		; centred calibration value

; ******************************************************************

; start at memory 0

	org		0			; reset vector

; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'			; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	clrf		ANSEL		; digital I/O
	movlw	B'00100100'	; pullups on/off
	movwf	WPU
	movlw	B'00100100'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000000'	; settings (pullups enabled) 
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0

	call		DELAYms

; adjust OSCCAL
ADJUST
; is up switch pressed?
	btfss	GPIO,5
	goto	UP
; is down switch pressed?
	btfsc	GPIO,2
	goto	ADJUST

DOWN
;initially get  calibration value from EEPROM
	call		EEPROM_READ
	movwf	CALIBRATE
;decrease
	decf	CALIBRATE,f
COMMON 
	movf	CALIBRATE,w

	bsf		STATUS,RP0	; bank 1
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; write to EEPROM
	call		EEPROM_READ; sets EEADR
	movf	CALIBRATE,w
	call		EEPROM_WRITE
; switch delay
	movlw	D'4'
	movwf	STORE3
LOOP
	call		DELAYms
	decfsz	STORE3,f
	goto	LOOP
	
	goto	ADJUST

UP	
;initially get  calibration value from EEPROM
	call		EEPROM_READ
	movwf	CALIBRATE
; increase
	incf		CALIBRATE,f
	goto	COMMON
		


; subroutines

; delay loop 

DELAYms
	movlw	D'255'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; read mode
EEPROM_READ
	bsf 	STATUS,RP0 	; Bank 1
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address to read
	bsf 	EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEPROM_WRITE
	clrwdt
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
;	movlw 	EEPROM0		;
;	movwf 	EEADR 		; Address
	bsf 	EECON1,WREN ; Enable write
;	bcf 	INTCON,GIE 	; Disable Interrupts
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 	EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	bcf		PIR1,EEIF	; clear end of write bit
WRITE
	btfsc	PIR1,EEIF
	goto	READY_RETURN
	goto	WRITE
READY_RETURN
	bsf 	STATUS,RP0 	; Bank 1
	bcf 	EECON1,WREN ; disable write
	bcf		STATUS,RP0	; Bank 0
	return

                

	end
